<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ItemReservation extends Model 
{

    protected $table = 'item_reservation';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('reservation_id', 'item_id', 'created_by', 'updated_by');

    public function reservations()
    {
        return $this->hasMany('App\Models\Reservation', 'reservation_id');
    }

    public function items()
    {
        return $this->hasMany('App\Models\Item', 'item_id');
    }

}